/*
 * Decompiled with CFR 0.152.
 */
package core.modes;

import core.GameWindow;
import core.Sprite;
import core.modes.GameMode;
import core.states.GameState;
import entities.creatures.enemies.MinionEntity;
import util.Config;
import util.ResourceManager;

public class SurvivalGameMode
extends GameMode {
    protected Sprite guiEnemies = ResourceManager.get().getSprite("interface/enemies");

    public SurvivalGameMode(GameState gamestate) {
        super(gamestate);
    }

    @Override
    public void startScreen() {
        this.window.drawText(GameWindow.FONT_MENU, this.width / 2, 220.0f, "In survival mode there is no end,\nthe game will always get harder.\n\nHow far can you go?", 2);
    }

    @Override
    public void startLevel() {
        super.startLevel();
        this.buildMinions();
    }

    protected void buildMinions() {
        int row = 0;
        while (row < Math.min(Config.get(Config.minionRows) + (int)(Config.get(Config.minionRowsPerLevel) * (float)this.level), Config.get(Config.minionRowsCap))) {
            int x = 0;
            while (x < Math.min(Config.get(Config.minionCols) + (int)(Config.get(Config.minionColsPerLevel) * (float)this.level), Config.get(Config.minionColsCap))) {
                MinionEntity minion = new MinionEntity(this.gamestate, 100 + x * 49, 10 + row * 30);
                this.gamestate.addEntity(minion);
                if (this.random.nextInt(Config.get(Config.superminionAppearChance) + Config.get(Config.superminionAppearChancePerLevel) * this.level) > 100000) {
                    minion.makeSuperminion();
                }
                ++x;
            }
            ++row;
        }
    }

    @Override
    public void render(long delta) {
        this.drawEnemyCount();
    }

    public void drawEnemyCount() {
        this.guiEnemies.draw(635, this.height - this.guiEnemies.getHeight() - 2);
        this.window.drawText(GameWindow.FONT_MAIN_DIFFICULTY[this.gamestate.getDifficultyInt()], 630.0f, 573.0f, String.valueOf(this.gamestate.getEnemyCount()) + "/" + this.gamestate.getMaxEnemyCount(), 3);
    }
}

